unit uPrepInvDataThread;

interface

uses
  System.Classes, System.SysUtils, Vcl.StdCtrls, Vcl.ComCtrls, Dialogs, DB,
  ADODB, System.UITypes;

type
  TPrepInvDataThread = class(TThread)
  private
    ErrorCode:string;
    CreateQ : TADOQuery;
    DataQ : TADOQuery;
    InsertQ : TADOQuery;
    SelectDocs : TADOQuery;
    SelAllCB : TCheckBox;
    SelAllBtn : TButton;
    PrepareBtn : TButton;
    PrintBtn: TButton;
    WorkSheet: TTabSheet;
    InvoicesSheet: TTabSheet;
    RefreshBtn: TButton;
    StatusBar: TStatusBar;
    ProgressBar: TProgressBar;
    PBStyle: TProgressBarStyle;

    procedure ErrorCheck;
    procedure SetProgressBarStyle;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; CCreateQ, CDataQ, CInsertQ,
                       CSelectDocs: TADOQuery; CSelAllCB: TCheckBox; CSelAllBtn, CPrepareBtn,
                       CRefreshBtn, CPrintBtn: TButton; CWorkSheet, CInvoicesSheet: TTabSheet;
                       CStatusBar: TStatusBar; CProgressBar: TProgressBar); overload;
  end;

var
  PrepInvDataThread: TPrepInvDataThread;

implementation


{ TPrepareInvoicesData }

constructor TPrepInvDataThread.Create(CreateSuspended: Boolean; CCreateQ, CDataQ, CInsertQ,
                                      CSelectDocs: TADOQuery; CSelAllCB: TCheckBox; CSelAllBtn,
                                      CPrepareBtn, CRefreshBtn, CPrintBtn: TButton; CWorkSheet, CInvoicesSheet: TTabSheet;
                                      CStatusBar: TStatusBar; CProgressBar: TProgressBar);
begin
  inherited Create(CreateSuspended);

  Self.CreateQ := CCreateQ;
  Self.DataQ := CDataQ;
  Self.InsertQ := CInsertQ;
  Self.SelectDocs := CSelectDocs;
  Self.SelAllCB := CSelAllCB;
  Self.SelAllBtn := CSelAllBtn;
  Self.PrepareBtn := CPrepareBtn;
  Self.RefreshBtn := CRefreshBtn;
  Self.PrintBtn := CPrintBtn;
  Self.WorkSheet := CWorkSheet;
  Self.InvoicesSheet := CInvoicesSheet;
  Self.StatusBar := CStatusBar;
  Self.ProgressBar := CProgressBar;
end;

procedure TPrepInvDataThread.SetProgressBarStyle;
begin
  ProgressBar.Style := Self.PBStyle;
end;

procedure TPrepInvDataThread.ErrorCheck;
begin
  if ErrorCode<>'0' then MessageDlg(ErrorCode,mtError,[mbOK],0);
end;

procedure TPrepInvDataThread.Execute;
var i:Integer;
begin
  Self.PBStyle := pbstMarquee;
  Synchronize(SetProgressBarStyle);

  try
    CreateQ.ExecSQL;
    DataQ.Open;

    while not DataQ.Eof do
    begin
      InsertQ.Parameters[0].Value := True;
      for i := 1 to InsertQ.Parameters.Count-1 do
      begin
        InsertQ.Parameters[i].Value := DataQ.FieldByName(InsertQ.Parameters[i].Name).AsVariant;
      end;

      try
        InsertQ.ExecSQL;
      except
        on E : Exception do
        begin
          ErrorCode := ' : '+E.ClassName+', : '+E.Message;
          Synchronize(ErrorCheck);
          Break;
        end;
      end;

      DataQ.Next;
    end;

    SelectDocs.Close;
    Synchronize(SelectDocs.Open);

    Self.StatusBar.Panels[0].Text := ': '+IntToStr(SelectDocs.RecordCount);

    Self.SelAllCB.Enabled := not SelectDocs.IsEmpty;
    Self.SelAllBtn.Enabled := not SelectDocs.IsEmpty;
    Self.PrepareBtn.Enabled := not SelectDocs.IsEmpty;
    Self.PrintBtn.Enabled := not SelectDocs.IsEmpty;
  except
    on E : Exception do
    begin
      ErrorCode := ' : '+E.ClassName+', : '+E.Message;
      Synchronize(ErrorCheck);
    end;
  end;

  Self.RefreshBtn.Enabled := True;
  Self.WorkSheet.Enabled := True;
  Self.InvoicesSheet.Enabled := True;

  Self.PBStyle := pbstNormal;
  Synchronize(SetProgressBarStyle);
end;

end.
